/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

$(function(){
    
	/***************************************************************************************************************/	
	/* 1. Load Tooltips															   				   				   */
	/***************************************************************************************************************/
	
	//we're using tippy for the tooltip
	tippy('[data-tippy-content]',{
		trigger: 'click',
		placement: 'bottom',
		boundary: 'window',
		arrow: true
	});
	
	
	/***************************************************************************************************************/	
	/* 2. Attach event to 'Save Settings' button																   */
	/***************************************************************************************************************/
	$("#button_save_main_settings").on('click',function(){
		
		if($("#button_save_main_settings").text() != 'Saving...'){
				
				//display loader while saving
				$("#button_save_main_settings").prop("disabled",true);
				$("#button_save_main_settings").text('Saving...');
				$("#button_save_main_settings").after("<img style=\"margin-left: 10px\" src='images/loader_small_grey.gif' />");
				
				$("#ms_form").trigger("submit");
		}
		
		
		return false;
	});

	/***************************************************************************************************************/	
	/* 3. Dialog Box for change password																		   */
	/***************************************************************************************************************/
	
	$("#ms_change_password").on('click',function(){
		
		Swal.fire({
			title: 'Change User Password',
			html: $("#dialog-change-password").html(),
			width: '30%',
			customClass: {
				footer: 'swal2-footer-info',
				title: 'swal2-title-warning'
			},
			didOpen: () => {
				$("#dialog-change-password-input1").trigger("focus");
			},
			confirmButtonText: 'Save Password',
			cancelButtonText: 'Cancel',
			showCancelButton: true,
			showConfirmButton: true,
			showLoaderOnConfirm: true,
			allowOutsideClick: () => !Swal.isLoading(),
			preConfirm: (tagnames) => {
				var password_1 = $("#dialog-change-password-input1").val().trim();
				var password_2 = $("#dialog-change-password-input2").val().trim();
				var current_user_id = $("#ms_box_account").data("userid");
				var csrf_token  	= $("#ms_box_account").data("csrftoken");

				if(password_1 == "" || password_2 == ""){
					Swal.showValidationMessage('Error: Please fill in both password fields!');
					return false;
				}else if(password_1 != password_2){
					Swal.showValidationMessage('Error: Please enter the same password in both fields!');
					return false;
				}

				return axios.post('change_password.php', {
					np: password_1,
					user_id: current_user_id,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						Swal.fire({
							toast: true,
							position: 'center',
							icon: 'success',
							title: 'Password changed.',
							showConfirmButton: false,
							timer: 2000
						});
						
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);;
				});
			}
		});

		return false;
	});

	/***************************************************************************************************************/	
	/* 4. 2-Step Verification Events																			   */
	/***************************************************************************************************************/

	//attach event to 'enable 2-step verification' checkbox
	$("#tsv_enable").on('click',function(){
		if($(this).prop("checked") == true){
			$("#ms_box_user_tsv .ms_box_email").slideDown();
		}else{
			$("#ms_box_user_tsv .ms_box_email").slideUp();
		}
	});

	//initialize qrcode if TSV is currently disabled
	if($("#tsv_enable").prop("checked") == false){
		var qrcode = new QRCode(document.getElementById("qrcode"), { width : 140, height : 140 });
		qrcode.makeCode($("#qrcode").data('totpdata'));	
	}

	//attach event to 'Verify Code' button
	$("#button_verify_tsv").on('click',function(){

		if($("#button_verify_tsv").text() != 'Verifying...'){
				
				//display loader while verifying
				$("#button_verify_tsv").prop("disabled",true);
				$("#button_verify_tsv").text('Verifying...');
				$("#button_verify_tsv").after("<img style=\"margin-left: 10px\" src='images/loader_small_grey.gif' />");
				
				var csrf_token  = $("#ms_box_account").data("csrftoken");

				//do the ajax call to verify the code
				axios.post('my_account_verify_tsv.php', {
					tsv_secret: $("#qrcode").data("tsvsecret"),
					tsv_code: $("#tsv_confirm_token").val(),
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						//display success dialog
						Swal.fire({
							toast: true,
							position: 'center',
							icon: 'success',
							title: '2-Step Verification Activated!',
							showConfirmButton: true
						}).then((result) => {
							if(result.isConfirmed) {
								window.location.replace('my_account.php');
							}
						});
					}else{
						Swal.fire({
							title: 'Error!',
							html: `Invalid security code. <br/>Please double-check and enter the correct code.`,
							customClass: {
								title: 'swal2-title-warning',
								htmlContainer: 'swal2-html-container-bold'
							},
							icon: 'error',
							width: '30%',
							allowOutsideClick: true,
							didClose: () => {
								$("#button_verify_tsv").prop("disabled",false);
								$("#button_verify_tsv").text('Verify Code');
								$("#button_verify_tsv").next().remove();
							}
						});
					}

					$("#button_verify_tsv").prop("disabled",false);
					$("#button_verify_tsv").text('Verify Code');
					$("#button_verify_tsv").next().remove();
				})
				.catch(function (error) {
					alert('Unable to verify code!');

					$("#button_verify_tsv").prop("disabled",false);
					$("#button_verify_tsv").text('Verify Code');
					$("#button_verify_tsv").next().remove();
				});
				
		}

		return false;
	});

});